<?php
namespace BuddyBossTheme\Admin\Mothership;

?>
<div class="wrap buddyboss-mothership-wrap">

	<h2><?php echo esc_html( BB_Theme_License_Page::pageTitle() ); ?></h2>

	<div class="buddyboss-mothership-block-container">
		<div class="buddyboss-mothership-block">
			<div class="inside">
				<h2><?php esc_html_e( 'Auto Connect (Recommended)', 'buddyboss-theme' ); ?></h2>
				<p>
					<?php printf( esc_html__( 'Click the "Connect to BuddyBoss" button to log into your BuddyBoss account. Then click "Allow" to have your license automatically filled in to activate your products.', 'buddyboss-theme' ) ); ?>
				</p>
				<br/>
				<button id="btn_bb_connect" class="button button-primary">
					<?php esc_html_e( 'Connect to BuddyBoss', 'buddyboss-theme' ); ?>
				</button>
				<span class="connecting" style="display:none;"><?php esc_html_e( 'Connecting', 'buddyboss-theme' ); ?></span>
			</div>
		</div>

		<div class="buddyboss-mothership-block">
			<div class="inside">
				<h2><?php esc_html_e( 'Manual Connect', 'buddyboss-theme' ); ?></h2>
				<p>
					<li>
						<?php printf( __( 'Log into %s', 'buddyboss-theme' ), '<a href="https://my.buddyboss.com/wp-admin">BuddyBoss.com</a>' ); ?>
					</li>
					<li>
						<?php printf( __( 'Go to your %s', 'buddyboss-theme' ), '<a href="https://my.buddyboss.com/my-account/">Account</a>' ); ?>
					</li>
					<li>
						<?php esc_html_e( 'Go to the "Subscriptions" tab', 'buddyboss-theme' ); ?>
					</li>
					<li>
						<?php esc_html_e( 'Find your product\'s license key', 'buddyboss-theme' ); ?>
					</li>
					<li>
						<?php esc_html_e( 'Enter your license key below', 'buddyboss-theme' ); ?>
					</li>
					<li>
						<?php esc_html_e( 'Enter your BuddyBoss account email', 'buddyboss-theme' ); ?>
					</li>
					<li>
						<?php esc_html_e( 'Click "Update License"', 'buddyboss-theme' ); ?>
					</li>
				</p>
			</div>
		</div>

		<div class="buddyboss-mothership-block">
			<div class="inside">
				<h2><?php esc_html_e( 'Benefits of a License', 'buddyboss-theme' ); ?></h2>
				<ul>
					<li>
						<strong><?php esc_html_e( 'Stay Up to Date', 'buddyboss-theme' ); ?></strong><br/>
						<?php esc_html_e( 'Get the latest features right away', 'buddyboss-theme' ); ?>
					</li>
					<li>
						<strong><?php esc_html_e( 'Admin Notifications', 'buddyboss-theme' ); ?></strong><br/>
						<?php esc_html_e( 'Get updates in WordPress', 'buddyboss-theme' ); ?>
					</li>
					<li>
						<strong><?php esc_html_e( 'Professional Support', 'buddyboss-theme' ); ?></strong><br/>
						<?php esc_html_e( 'Get help with any questions', 'buddyboss-theme' ); ?>
					</li>
				</ul>
			</div>
		</div>

	</div>

	<div class='buddyboss-mothership-settings clearfix'>
		<?php
			// Use our custom BB_Theme_License_Manager instead of the base LicenseManager.
			$licenseManager = new BB_Theme_License_Manager();
			echo '<div class="setting-wrapper">';
			echo $licenseManager->generateLicenseActivationForm(); // phpcs:ignore WordPress.Security.EscapeOutput.OutputNotEscaped
			echo '</div>';
		?>
	</div><!-- .buddyboss-mothership-settings -->

</div>
